-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;




--
-- Definition of table `persona`
--

DROP TABLE IF EXISTS `persona`;
CREATE TABLE `persona` (
  `idpersona` int(11) NOT NULL AUTO_INCREMENT,
  `NombreyApellidos` varchar(100) NOT NULL,
  `persona_genero_idpersona_genero` int(11) NOT NULL DEFAULT '1',
  `persona_embarazo_idpersona_embarazo` int(11) NOT NULL DEFAULT '1',
  `persona_rol_idpersona_rol` int(11) NOT NULL,
  `persona_activo_idpersona_activo` int(11) NOT NULL DEFAULT '1',
  `proxima_revision` date DEFAULT NULL,
  PRIMARY KEY (`idpersona`),
  KEY `fk_persona_persona_genero_idx` (`persona_genero_idpersona_genero`),
  KEY `fk_persona_persona_embarazo1_idx` (`persona_embarazo_idpersona_embarazo`),
  KEY `fk_persona_persona_rol1_idx` (`persona_rol_idpersona_rol`),
  KEY `fk_persona_persona_activo1_idx` (`persona_activo_idpersona_activo`),
  CONSTRAINT `fk_persona_persona_activo1` FOREIGN KEY (`persona_activo_idpersona_activo`) REFERENCES `persona_activo` (`idpersona_activo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_persona_persona_embarazo1` FOREIGN KEY (`persona_embarazo_idpersona_embarazo`) REFERENCES `persona_embarazo` (`idpersona_embarazo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_persona_persona_genero` FOREIGN KEY (`persona_genero_idpersona_genero`) REFERENCES `persona_genero` (`idpersona_genero`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_persona_persona_rol1` FOREIGN KEY (`persona_rol_idpersona_rol`) REFERENCES `persona_rol` (`idpersona_rol`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona`
--

/*!40000 ALTER TABLE `persona` DISABLE KEYS */;
INSERT INTO `persona` (`idpersona`,`NombreyApellidos`,`persona_genero_idpersona_genero`,`persona_embarazo_idpersona_embarazo`,`persona_rol_idpersona_rol`,`persona_activo_idpersona_activo`,`proxima_revision`) VALUES 
 (1,'Fernando',1,1,1,1,'2020-07-31'),
 (2,'Juana',2,2,1,2,NULL),
 (3,'Pedro',1,1,2,1,'2020-07-24'),
 (4,'María',2,1,2,1,'2020-08-11');
/*!40000 ALTER TABLE `persona` ENABLE KEYS */;


--
-- Definition of table `persona_activo`
--

DROP TABLE IF EXISTS `persona_activo`;
CREATE TABLE `persona_activo` (
  `idpersona_activo` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(40) NOT NULL,
  `Sigla` varchar(2) NOT NULL,
  PRIMARY KEY (`idpersona_activo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_activo`
--

/*!40000 ALTER TABLE `persona_activo` DISABLE KEYS */;
INSERT INTO `persona_activo` (`idpersona_activo`,`Titulo`,`Sigla`) VALUES 
 (1,'Activo','AC'),
 (2,'Baja','BJ');
/*!40000 ALTER TABLE `persona_activo` ENABLE KEYS */;


--
-- Definition of table `persona_embarazo`
--

DROP TABLE IF EXISTS `persona_embarazo`;
CREATE TABLE `persona_embarazo` (
  `idpersona_embarazo` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(15) NOT NULL,
  `Sigla` varchar(2) NOT NULL,
  PRIMARY KEY (`idpersona_embarazo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_embarazo`
--

/*!40000 ALTER TABLE `persona_embarazo` DISABLE KEYS */;
INSERT INTO `persona_embarazo` (`idpersona_embarazo`,`Titulo`,`Sigla`) VALUES 
 (1,'No','N'),
 (2,'Sí','S');
/*!40000 ALTER TABLE `persona_embarazo` ENABLE KEYS */;


--
-- Definition of table `persona_genero`
--

DROP TABLE IF EXISTS `persona_genero`;
CREATE TABLE `persona_genero` (
  `idpersona_genero` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(30) NOT NULL,
  `Sigla` varchar(2) NOT NULL,
  PRIMARY KEY (`idpersona_genero`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_genero`
--

/*!40000 ALTER TABLE `persona_genero` DISABLE KEYS */;
INSERT INTO `persona_genero` (`idpersona_genero`,`Titulo`,`Sigla`) VALUES 
 (1,'Masculino','M'),
 (2,'Femenino','F'),
 (3,'Sin Dato','SD');
/*!40000 ALTER TABLE `persona_genero` ENABLE KEYS */;


--
-- Definition of table `persona_historico`
--

DROP TABLE IF EXISTS `persona_historico`;
CREATE TABLE `persona_historico` (
  `idpersona_historico` int(11) NOT NULL AUTO_INCREMENT,
  `Fecha` datetime NOT NULL,
  `persona_idpersona` int(11) NOT NULL,
  `persona_prestacion_idpersona_prestacion` int(11) NOT NULL,
  PRIMARY KEY (`idpersona_historico`),
  KEY `fk_persona_historico_persona1_idx` (`persona_idpersona`),
  KEY `fk_persona_historico_persona_prestacion1_idx` (`persona_prestacion_idpersona_prestacion`),
  CONSTRAINT `fk_persona_historico_persona1` FOREIGN KEY (`persona_idpersona`) REFERENCES `persona` (`idpersona`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_persona_historico_persona_prestacion1` FOREIGN KEY (`persona_prestacion_idpersona_prestacion`) REFERENCES `persona_prestacion` (`idpersona_prestacion`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_historico`
--

/*!40000 ALTER TABLE `persona_historico` DISABLE KEYS */;
INSERT INTO `persona_historico` (`idpersona_historico`,`Fecha`,`persona_idpersona`,`persona_prestacion_idpersona_prestacion`) VALUES 
 (1,'2020-06-23 00:00:00',1,2),
 (2,'2020-06-23 00:00:00',2,3),
 (3,'2020-06-25 00:00:00',1,2),
 (4,'2020-06-25 00:00:00',1,2),
 (6,'2020-07-27 00:00:00',4,2);
/*!40000 ALTER TABLE `persona_historico` ENABLE KEYS */;


--
-- Definition of table `persona_prestacion`
--

DROP TABLE IF EXISTS `persona_prestacion`;
CREATE TABLE `persona_prestacion` (
  `idpersona_prestacion` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(40) NOT NULL,
  `Sigla` varchar(2) NOT NULL,
  `persona_rol_idpersona_rol` varchar(60) NOT NULL,
  PRIMARY KEY (`idpersona_prestacion`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_prestacion`
--

/*!40000 ALTER TABLE `persona_prestacion` DISABLE KEYS */;
INSERT INTO `persona_prestacion` (`idpersona_prestacion`,`Titulo`,`Sigla`,`persona_rol_idpersona_rol`) VALUES 
 (1,'Focalizados','FO','4,3'),
 (2,'Discapacitados','DI','4,2,3,1'),
 (3,'Embarazadas','EM','2,1'),
 (4,'Adulto Mayor','AM','4');
/*!40000 ALTER TABLE `persona_prestacion` ENABLE KEYS */;


--
-- Definition of table `persona_rol`
--

DROP TABLE IF EXISTS `persona_rol`;
CREATE TABLE `persona_rol` (
  `idpersona_rol` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(40) NOT NULL,
  `Sigla` varchar(2) NOT NULL,
  PRIMARY KEY (`idpersona_rol`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_rol`
--

/*!40000 ALTER TABLE `persona_rol` DISABLE KEYS */;
INSERT INTO `persona_rol` (`idpersona_rol`,`Titulo`,`Sigla`) VALUES 
 (1,'Tutor','TU'),
 (2,'Co-Tutor','CT'),
 (3,'Menor','ME'),
 (4,'Adulto Mayor','AM');
/*!40000 ALTER TABLE `persona_rol` ENABLE KEYS */;


--
-- Definition of table `persona_subvencion`
--

DROP TABLE IF EXISTS `persona_subvencion`;
CREATE TABLE `persona_subvencion` (
  `idpersona_subvencion` int(11) NOT NULL AUTO_INCREMENT,
  `persona_idpersona` int(11) NOT NULL,
  `importe` decimal(9,2) NOT NULL,
  `importe_embarazada` decimal(9,2) NOT NULL,
  PRIMARY KEY (`idpersona_subvencion`),
  KEY `fk_persona_subvencion_persona1_idx` (`persona_idpersona`),
  CONSTRAINT `fk_persona_subvencion_persona1` FOREIGN KEY (`persona_idpersona`) REFERENCES `persona` (`idpersona`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `persona_subvencion`
--

/*!40000 ALTER TABLE `persona_subvencion` DISABLE KEYS */;
INSERT INTO `persona_subvencion` (`idpersona_subvencion`,`persona_idpersona`,`importe`,`importe_embarazada`) VALUES 
 (2,1,'14.00','0.00'),
 (3,2,'15.00','10.50'),
 (4,4,'25.00','0.00');
/*!40000 ALTER TABLE `persona_subvencion` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
